% Conduct the experiments in Subsection 4.2 
% using the proposed method and nCor.

clear all
close all

rand('state',1)
randn('state',1)

load Lines

x = rand(10000,1);
y{1} = x;
y{2} = sin(4*pi*x);
y{3} = x;
y{3}(length(x)/2:end) = 0.1*x(length(x)/2:end) ;
y{4} = x;
y{4}(length(x)/2:end) = -1*(x(length(x)/2:end)-.5).^2+.25;
y{5} = 2*(x-.5);
y{5}(length(x)/2:end) = -2*(x(length(x)/2:end)-.5);

t = sort(x')*2*pi;
cx=-cos(t);
cy=3*sin(t)+1*cx;
cx = (cx-min(cx))/(max(cx)-min(cx));
cy = (cy-min(cy))/(max(cy)-min(cy));
a = randperm(length(cx));
cx = cx(a)';
cy = cy(a)';
cu = sin(t(a))';

y{7} = sin(4*pi*x);
y{7}(length(x)/2:end) = sin(10*pi*x(length(x)/2:end));

dx = x;
dy = x;
dx(1:length(x)/2) = 0;
dy(length(x)/2:end) = 0;



kk = 0.05*ones(1,8);
kk(7) = kk(7)/2;
for i = 1:8
    e1 = kk(i)*(rand(size(x))-.5);
    e2 = kk(i)*(rand(size(x))-.5);
    if i == 6
        xx{i} = cx;
        xx{i} = cx+e1;
        yy{i} = cy+e2;
        uu{i} = cu;
    elseif i == 8
        xx{i} = dx;
        xx{i} = dx+e1;
        yy{i} = dy+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    else
        xx{i} = x;
        xx{i} = x+e1;
        yy{i} = y{i}+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    end
end

a = [0 1;-1 1;0 1;0 1;-1 1;0 1;-1 1;0 1];
a(:,1) = a(:,1)-.15;
a(:,2) = a(:,2)+.15;

k = 0;
for i = 1:2
    for j = 1:4
        k = k+1;
        [r1(1,k), r2(1,k)] = ncor2(xx{k},yy{k});
        rr(1,k) = ncor2([xx{k},uu{k}],yy{k});
        
        if j<3
            figure(1+i*2-2)
        else
            figure(2+i*2-2)
        end
        if mod(j,2)==1
            kkk = 1;
        else
            kkk = 2;
        end
        
        subplot(3,4,kkk)
        kk = randperm(length(yy{k}));
        kk = kk(1:ceil(length(kk)/2));
        plot(xx{k}(kk),yy{k}(kk),'ok','MarkerSize',1,'LineWidth',.1)
        box off
        set(gca,'xtick',[]);
        set(gca,'ytick',[]);
        axis([-.15 1.15 a(k,1) a(k,2)])
        text(.5,a(k,2)+.05*(a(k,2)-a(k,1)),['D',num2str(k),'-xyS'],'FontSize',22,'HorizontalAlignment','center',...
            'VerticalAlignment','bottom','Fontname', 'Times New Roman')
        
        if i==1&&j<3
            xt = Lines.xt{1,j};
            ey = Lines.ey{1,j};
            hold on
            plot(xt,ey,'-r','LineWidth',2)
            hold off
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%

kk = 0.2*ones(1,8);
kk(7) = kk(7)/2;
for i = 1:8
    e1 = kk(i)*(rand(size(x))-.5);
    e2 = kk(i)*(rand(size(x))-.5);
    e2 = zeros(size(e2));
    if i == 6
        xx{i} = cx;
        xx{i} = cx+e1;
        yy{i} = cy+e2;
        uu{i} = cu;
    elseif i == 8
        xx{i} = dx;
        xx{i} = dx+e1;
        yy{i} = dy+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    else
        xx{i} = x;
        xx{i} = x+e1;
        yy{i} = y{i}+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    end
end

a = [0 1;-1 1;0 1;0 1;-1 1;0 1;-1 1;0 1];
a(:,1) = a(:,1)-.15;
a(:,2) = a(:,2)+.15;

k = 0;
for i = 1:2
    for j = 1:4
        
        k = k+1;
        [r1(4,k),r2(4,k)] = ncor2(xx{k},yy{k});
        rr(4,k) = ncor2([xx{k},uu{k}],yy{k});
        
        if j<3
            figure(5+i*2-2)
        else
            figure(6+i*2-2)
        end
        if mod(j,2)==1
            kkk = 5;
        else
            kkk = 6;
        end
        
        subplot(3,4,kkk)
        kk = randperm(length(yy{k}));
        kk = kk(1:ceil(length(kk)/2));
        plot(xx{k}(kk),yy{k}(kk),'ok','MarkerSize',1,'LineWidth',.1)
        box off
        set(gca,'xtick',[]);
        set(gca,'ytick',[]);
        if k ==11
            axis([-.25 1.25 a(k,1) a(k,2)])
        else
            axis([-.15 1.15 a(k,1) a(k,2)])
        end
        text(.5,a(k,2)+.05*(a(k,2)-a(k,1)),['D',num2str(k),'-xL'],'FontSize',22,'HorizontalAlignment','center',...
            'VerticalAlignment','bottom','Fontname', 'Times New Roman')
        
        if i==1&&j<3
            xt = Lines.xt{3,j};
            ey = Lines.ey{3,j};
            hold on
            plot(xt,ey,'-r','LineWidth',2)
            hold off
        end
    end
end


%%%%%%%%%%%%%%%%%%%%%%

kk = 0.2*ones(1,8);
kk(2) = kk(2)*2;
for i = 1:8
    e1 = kk(i)*(rand(size(x))-.5);
    e2 = kk(i)*(rand(size(x))-.5);
    if i == 6
        xx{i} = cx;
        yy{i} = cy+e2;
        uu{i} = cu;
    elseif i == 8
        xx{i} = dx;
        yy{i} = dy+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    else
        xx{i} = x;
        yy{i} = y{i}+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    end
end

a = [-0 1;-1.1 1.1;0 1;0 1;-1 1;0 1;-1 1;0 1];
a(:,1) = a(:,1)-.15;
a(:,2) = a(:,2)+.15;

k = 0;
for i = 1:2
    for j = 1:4
        
        k = k+1;
        [r1(3,k),r2(3,k)] = ncor2(xx{k},yy{k});
        rr(3,k) = ncor2([xx{k},uu{k}],yy{k});
        
        if j<3
            figure(5+i*2-2)
        else
            figure(6+i*2-2)
        end
        if mod(j,2)==1
            kkk = 1;
        else
            kkk = 2;
        end
        
        subplot(3,4,kkk)
        kk = randperm(length(yy{k}));
        kk = kk(1:ceil(length(kk)/2));
        plot(xx{k}(kk),yy{k}(kk),'ok','MarkerSize',1,'LineWidth',.1)
        box off
        set(gca,'xtick',[]);
        set(gca,'ytick',[]);
        axis([-.05 1.05 a(k,1) a(k,2)])        
        text(.5,a(k,2)+.05*(a(k,2)-a(k,1)),['D',num2str(k),'-yL'],'FontSize',22,'HorizontalAlignment','center',...
            'VerticalAlignment','bottom','Fontname', 'Times New Roman')
        
        if i==1&&j<3
            xt = Lines.xt{4,j};
            ey = Lines.ey{4,j};
            hold on
            plot(xt,ey,'-r','LineWidth',2)
            hold off
        end
    end
end


%%%%%%%%%%%%%%%%%%%%%%

kk = 0.2*ones(1,8);
kk(7) = kk(7)/2;
for i = 1:8
    e1 = kk(i)*(rand(size(x))-.5);
    e2 = kk(i)*(rand(size(x))-.5);
    if i == 6
        xx{i} = cx;
        xx{i} = cx+e1;
        yy{i} = cy+e2;
        uu{i} = cu;
    elseif i == 8
        xx{i} = dx;
        xx{i} = dx+e1;
        yy{i} = dy+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    else
        xx{i} = x;
        xx{i} = x+e1;
        yy{i} = y{i}+e2;
        uu{i} = zeros(size(xx{i}));
        uu{i}(length(x)/2:end) = 1;
    end
end

a = [0 1;-1 1;0 1;0 1;-1 1;0 1;-1 1;0 1];
a(:,1) = a(:,1)-.15;
a(:,2) = a(:,2)+.15;

k = 0;
for i = 1:2
    for j = 1:4
        
        k = k+1;
        [r1(2,k),r2(2,k)] = ncor2(xx{k},yy{k});
        rr(2,k) = ncor2([xx{k},uu{k}],yy{k});
        
        if j<3
            figure(1+i*2-2)
        else
            figure(2+i*2-2)
        end
        if mod(j,2)==1
            kkk = 5;
        else
            kkk = 6;
        end
        
        subplot(3,4,kkk)
        kk = randperm(length(yy{k}));
        kk = kk(1:ceil(length(kk)/2));
        plot(xx{k}(kk),yy{k}(kk),'ok','MarkerSize',1,'LineWidth',.1)
        box off
        set(gca,'xtick',[]);
        set(gca,'ytick',[]);
        if k ==11
            axis([-.25 1.25 a(k,1) a(k,2)])
        else
            axis([-.15 1.15 a(k,1) a(k,2)])
        end
        text(.5,a(k,2)+.05*(a(k,2)-a(k,1)),['D',num2str(k),'-xyL'],'FontSize',22,'HorizontalAlignment','center',...
            'VerticalAlignment','bottom','Fontname', 'Times New Roman')
        
        if i==1&&j<3
            xt = Lines.xt{2,j};
            ey = Lines.ey{2,j};
            hold on
            plot(xt,ey,'-r','LineWidth',2)
            hold off
        end
    end
end

